package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>> extends BaseFluent<A> implements HorizontalPodAutoscalerStatusFluent<A>{
  public HorizontalPodAutoscalerStatusFluentImpl() {
  }
  public HorizontalPodAutoscalerStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withCurrentMetrics(instance.getCurrentMetrics()); 
    this.withCurrentReplicas(instance.getCurrentReplicas()); 
    this.withDesiredReplicas(instance.getDesiredReplicas()); 
    this.withLastScaleTime(instance.getLastScaleTime()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<HorizontalPodAutoscalerConditionBuilder> conditions = new java.util.ArrayList<HorizontalPodAutoscalerConditionBuilder>();
  private java.util.ArrayList<MetricStatusBuilder> currentMetrics = new java.util.ArrayList<MetricStatusBuilder>();
  private Integer currentReplicas;
  private java.lang.Integer desiredReplicas;
  private String lastScaleTime;
  private Long observedGeneration;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition... items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition> items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new HorizontalPodAutoscalerCondition(lastTransitionTime, message, reason, status, type));
  }
  public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new HorizontalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item) {
    return new HorizontalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerCondition item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToCurrentMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item) {
    if (this.currentMetrics == null) {this.currentMetrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);_visitables.get("currentMetrics").add(index >= 0 ? index : _visitables.get("currentMetrics").size(), builder);this.currentMetrics.add(index >= 0 ? index : currentMetrics.size(), builder); return (A)this;
  }
  public A setToCurrentMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item) {
    if (this.currentMetrics == null) {this.currentMetrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("currentMetrics").size()) { _visitables.get("currentMetrics").add(builder); } else { _visitables.get("currentMetrics").set(index, builder);}
    if (index < 0 || index >= currentMetrics.size()) { currentMetrics.add(builder); } else { currentMetrics.set(index, builder);}
     return (A)this;
  }
  public A addToCurrentMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus... items) {
    if (this.currentMetrics == null) {this.currentMetrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);_visitables.get("currentMetrics").add(builder);this.currentMetrics.add(builder);} return (A)this;
  }
  public A addAllToCurrentMetrics(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus> items) {
    if (this.currentMetrics == null) {this.currentMetrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);_visitables.get("currentMetrics").add(builder);this.currentMetrics.add(builder);} return (A)this;
  }
  public A removeFromCurrentMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus... items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);_visitables.get("currentMetrics").remove(builder);if (this.currentMetrics != null) {this.currentMetrics.remove(builder);}} return (A)this;
  }
  public A removeAllFromCurrentMetrics(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus> items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(item);_visitables.get("currentMetrics").remove(builder);if (this.currentMetrics != null) {this.currentMetrics.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCurrentMetrics(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder> predicate) {
    if (currentMetrics == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder> each = currentMetrics.iterator();
    final List visitables = _visitables.get("currentMetrics");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCurrentMetrics instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus> getCurrentMetrics() {
    return currentMetrics != null ? build(currentMetrics) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus> buildCurrentMetrics() {
    return currentMetrics != null ? build(currentMetrics) : null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus buildCurrentMetric(java.lang.Integer index) {
    return this.currentMetrics.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus buildFirstCurrentMetric() {
    return this.currentMetrics.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus buildLastCurrentMetric() {
    return this.currentMetrics.get(currentMetrics.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus buildMatchingCurrentMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder item: currentMetrics) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCurrentMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder item: currentMetrics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCurrentMetrics(java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus> currentMetrics) {
    if (this.currentMetrics != null) { _visitables.get("currentMetrics").removeAll(this.currentMetrics);}
    if (currentMetrics != null) {this.currentMetrics = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item : currentMetrics){this.addToCurrentMetrics(item);}} else { this.currentMetrics = null;} return (A) this;
  }
  public A withCurrentMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus... currentMetrics) {
    if (this.currentMetrics != null) {this.currentMetrics.clear();}
    if (currentMetrics != null) {for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item :currentMetrics){ this.addToCurrentMetrics(item);}} return (A) this;
  }
  public java.lang.Boolean hasCurrentMetrics() {
    return currentMetrics != null && !currentMetrics.isEmpty();
  }
  public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetric() {
    return new HorizontalPodAutoscalerStatusFluentImpl.CurrentMetricsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetricLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluentImpl.CurrentMetricsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> setNewCurrentMetricLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluentImpl.CurrentMetricsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editCurrentMetric(java.lang.Integer index) {
    if (currentMetrics.size() <= index) throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
    return setNewCurrentMetricLike(index, buildCurrentMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editFirstCurrentMetric() {
    if (currentMetrics.size() == 0) throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
    return setNewCurrentMetricLike(0, buildCurrentMetric(0));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editLastCurrentMetric() {
    int index = currentMetrics.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
    return setNewCurrentMetricLike(index, buildCurrentMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editMatchingCurrentMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<currentMetrics.size();i++) { 
    if (predicate.test(currentMetrics.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
    return setNewCurrentMetricLike(index, buildCurrentMetric(index));
  }
  public java.lang.Integer getCurrentReplicas() {
    return this.currentReplicas;
  }
  public A withCurrentReplicas(java.lang.Integer currentReplicas) {
    this.currentReplicas=currentReplicas; return (A) this;
  }
  public java.lang.Boolean hasCurrentReplicas() {
    return this.currentReplicas != null;
  }
  public java.lang.Integer getDesiredReplicas() {
    return this.desiredReplicas;
  }
  public A withDesiredReplicas(java.lang.Integer desiredReplicas) {
    this.desiredReplicas=desiredReplicas; return (A) this;
  }
  public java.lang.Boolean hasDesiredReplicas() {
    return this.desiredReplicas != null;
  }
  public java.lang.String getLastScaleTime() {
    return this.lastScaleTime;
  }
  public A withLastScaleTime(java.lang.String lastScaleTime) {
    this.lastScaleTime=lastScaleTime; return (A) this;
  }
  public java.lang.Boolean hasLastScaleTime() {
    return this.lastScaleTime != null;
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentMetrics != null ? !currentMetrics.equals(that.currentMetrics) :that.currentMetrics != null) return false;
    if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
    if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
    if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  currentMetrics,  currentReplicas,  desiredReplicas,  lastScaleTime,  observedGeneration,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentMetrics != null && !currentMetrics.isEmpty()) { sb.append("currentMetrics:"); sb.append(currentMetrics + ","); }
    if (currentReplicas != null) { sb.append("currentReplicas:"); sb.append(currentReplicas + ","); }
    if (desiredReplicas != null) { sb.append("desiredReplicas:"); sb.append(desiredReplicas + ","); }
    if (lastScaleTime != null) { sb.append("lastScaleTime:"); sb.append(lastScaleTime + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends HorizontalPodAutoscalerConditionFluentImpl<HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,HorizontalPodAutoscalerCondition item) {
      this.index = index;
      this.builder = new HorizontalPodAutoscalerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HorizontalPodAutoscalerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class CurrentMetricsNestedImpl<N> extends MetricStatusFluentImpl<HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    CurrentMetricsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus item) {
      this.index = index;
      this.builder = new MetricStatusBuilder(this, item);
    }
    CurrentMetricsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HorizontalPodAutoscalerStatusFluentImpl.this.setToCurrentMetrics(index,builder.build());
    }
    public N endCurrentMetric() {
      return and();
    }
    
  }
  
}