package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerStatusBuilder extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder> implements VisitableBuilder<HorizontalPodAutoscalerStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusBuilder>{
  public HorizontalPodAutoscalerStatusBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerStatus(), validationEnabled);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
  }
  public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withCurrentMetrics(instance.getCurrentMetrics()); 
    fluent.withCurrentReplicas(instance.getCurrentReplicas()); 
    fluent.withDesiredReplicas(instance.getDesiredReplicas()); 
    fluent.withLastScaleTime(instance.getLastScaleTime()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withCurrentMetrics(instance.getCurrentMetrics()); 
    this.withCurrentReplicas(instance.getCurrentReplicas()); 
    this.withDesiredReplicas(instance.getDesiredReplicas()); 
    this.withLastScaleTime(instance.getLastScaleTime()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus build() {
    HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(fluent.getConditions(),fluent.getCurrentMetrics(),fluent.getCurrentReplicas(),fluent.getDesiredReplicas(),fluent.getLastScaleTime(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}