package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>> extends BaseFluent<A> implements HorizontalPodAutoscalerSpecFluent<A>{
  public HorizontalPodAutoscalerSpecFluentImpl() {
  }
  public HorizontalPodAutoscalerSpecFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec instance) {
    this.withBehavior(instance.getBehavior()); 
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMetrics(instance.getMetrics()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private HorizontalPodAutoscalerBehaviorBuilder behavior;
  private Integer maxReplicas;
  private ArrayList<MetricSpecBuilder> metrics = new java.util.ArrayList<MetricSpecBuilder>();
  private java.lang.Integer minReplicas;
  private CrossVersionObjectReferenceBuilder scaleTargetRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBehavior instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior getBehavior() {
    return this.behavior!=null ?this.behavior.build():null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior buildBehavior() {
    return this.behavior!=null ?this.behavior.build():null;
  }
  public A withBehavior(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior behavior) {
    _visitables.get("behavior").remove(this.behavior);
    if (behavior!=null){ this.behavior= new HorizontalPodAutoscalerBehaviorBuilder(behavior); _visitables.get("behavior").add(this.behavior);} return (A) this;
  }
  public Boolean hasBehavior() {
    return this.behavior != null;
  }
  public HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehavior() {
    return new HorizontalPodAutoscalerSpecFluentImpl.BehaviorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> withNewBehaviorLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior item) {
    return new HorizontalPodAutoscalerSpecFluentImpl.BehaviorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editBehavior() {
    return withNewBehaviorLike(getBehavior());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehavior() {
    return withNewBehaviorLike(getBehavior() != null ? getBehavior(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.BehaviorNested<A> editOrNewBehaviorLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior item) {
    return withNewBehaviorLike(getBehavior() != null ? getBehavior(): item);
  }
  public java.lang.Integer getMaxReplicas() {
    return this.maxReplicas;
  }
  public A withMaxReplicas(java.lang.Integer maxReplicas) {
    this.maxReplicas=maxReplicas; return (A) this;
  }
  public java.lang.Boolean hasMaxReplicas() {
    return this.maxReplicas != null;
  }
  public A addToMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);_visitables.get("metrics").add(index >= 0 ? index : _visitables.get("metrics").size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
  }
  public A setToMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("metrics").size()) { _visitables.get("metrics").add(builder); } else { _visitables.get("metrics").set(index, builder);}
    if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
     return (A)this;
  }
  public A addToMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec... items) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
  }
  public A addAllToMetrics(Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec> items) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
  }
  public A removeFromMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec... items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetrics(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec> items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetrics(Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder> predicate) {
    if (metrics == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder> each = metrics.iterator();
    final List visitables = _visitables.get("metrics");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetrics instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec> getMetrics() {
    return metrics != null ? build(metrics) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec> buildMetrics() {
    return metrics != null ? build(metrics) : null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec buildMetric(java.lang.Integer index) {
    return this.metrics.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec buildFirstMetric() {
    return this.metrics.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec buildLastMetric() {
    return this.metrics.get(metrics.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec buildMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetrics(java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec> metrics) {
    if (this.metrics != null) { _visitables.get("metrics").removeAll(this.metrics);}
    if (metrics != null) {this.metrics = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
  }
  public A withMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec... metrics) {
    if (this.metrics != null) {this.metrics.clear();}
    if (metrics != null) {for (io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item :metrics){ this.addToMetrics(item);}} return (A) this;
  }
  public java.lang.Boolean hasMetrics() {
    return metrics != null && !metrics.isEmpty();
  }
  public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
    return new HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(java.lang.Integer index) {
    if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
    if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
    return setNewMetricLike(0, buildMetric(0));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
    int index = metrics.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metrics.size();i++) { 
    if (predicate.test(metrics.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public java.lang.Integer getMinReplicas() {
    return this.minReplicas;
  }
  public A withMinReplicas(java.lang.Integer minReplicas) {
    this.minReplicas=minReplicas; return (A) this;
  }
  public java.lang.Boolean hasMinReplicas() {
    return this.minReplicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScaleTargetRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public CrossVersionObjectReference getScaleTargetRef() {
    return this.scaleTargetRef!=null ?this.scaleTargetRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference buildScaleTargetRef() {
    return this.scaleTargetRef!=null ?this.scaleTargetRef.build():null;
  }
  public A withScaleTargetRef(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference scaleTargetRef) {
    _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
    if (scaleTargetRef!=null){ this.scaleTargetRef= new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} return (A) this;
  }
  public java.lang.Boolean hasScaleTargetRef() {
    return this.scaleTargetRef != null;
  }
  public A withNewScaleTargetRef(java.lang.String apiVersion,java.lang.String kind,java.lang.String name) {
    return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
    return new HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReference item) {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
    if (behavior != null ? !behavior.equals(that.behavior) :that.behavior != null) return false;
    if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
    if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
    if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
    if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(behavior,  maxReplicas,  metrics,  minReplicas,  scaleTargetRef,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (behavior != null) { sb.append("behavior:"); sb.append(behavior + ","); }
    if (maxReplicas != null) { sb.append("maxReplicas:"); sb.append(maxReplicas + ","); }
    if (metrics != null && !metrics.isEmpty()) { sb.append("metrics:"); sb.append(metrics + ","); }
    if (minReplicas != null) { sb.append("minReplicas:"); sb.append(minReplicas + ","); }
    if (scaleTargetRef != null) { sb.append("scaleTargetRef:"); sb.append(scaleTargetRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BehaviorNestedImpl<N> extends HorizontalPodAutoscalerBehaviorFluentImpl<HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.BehaviorNested<N>,Nested<N>{
    BehaviorNestedImpl(HorizontalPodAutoscalerBehavior item) {
      this.builder = new HorizontalPodAutoscalerBehaviorBuilder(this, item);
    }
    BehaviorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder builder;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withBehavior(builder.build());
    }
    public N endBehavior() {
      return and();
    }
    
  }
  class MetricsNestedImpl<N> extends MetricSpecFluentImpl<HorizontalPodAutoscalerSpecFluent.MetricsNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetricsNestedImpl(java.lang.Integer index,MetricSpec item) {
      this.index = index;
      this.builder = new MetricSpecBuilder(this, item);
    }
    MetricsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(index,builder.build());
    }
    public N endMetric() {
      return and();
    }
    
  }
  class ScaleTargetRefNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ScaleTargetRefNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    ScaleTargetRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
    }
    public N endScaleTargetRef() {
      return and();
    }
    
  }
  
}