package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerBehaviorBuilder extends HorizontalPodAutoscalerBehaviorFluentImpl<HorizontalPodAutoscalerBehaviorBuilder> implements VisitableBuilder<HorizontalPodAutoscalerBehavior,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder>{
  public HorizontalPodAutoscalerBehaviorBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerBehavior(), validationEnabled);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerBehavior(), validationEnabled);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withScaleDown(instance.getScaleDown()); 
    fluent.withScaleUp(instance.getScaleUp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withScaleDown(instance.getScaleDown()); 
    this.withScaleUp(instance.getScaleUp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior build() {
    HorizontalPodAutoscalerBehavior buildable = new HorizontalPodAutoscalerBehavior(fluent.getScaleDown(),fluent.getScaleUp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}