package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HPAScalingRulesBuilder extends HPAScalingRulesFluentImpl<HPAScalingRulesBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesBuilder>{
  public HPAScalingRulesBuilder() {
    this(false);
  }
  public HPAScalingRulesBuilder(Boolean validationEnabled) {
    this(new HPAScalingRules(), validationEnabled);
  }
  public HPAScalingRulesBuilder(HPAScalingRulesFluent<?> fluent) {
    this(fluent, false);
  }
  public HPAScalingRulesBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HPAScalingRules(), validationEnabled);
  }
  public HPAScalingRulesBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules instance) {
    this(fluent, instance, false);
  }
  public HPAScalingRulesBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPolicies(instance.getPolicies()); 
    fluent.withSelectPolicy(instance.getSelectPolicy()); 
    fluent.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HPAScalingRulesBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules instance) {
    this(instance,false);
  }
  public HPAScalingRulesBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPolicies(instance.getPolicies()); 
    this.withSelectPolicy(instance.getSelectPolicy()); 
    this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRulesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingRules build() {
    HPAScalingRules buildable = new HPAScalingRules(fluent.getPolicies(),fluent.getSelectPolicy(),fluent.getStabilizationWindowSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}