package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HPAScalingPolicyBuilder extends HPAScalingPolicyFluentImpl<HPAScalingPolicyBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyBuilder>{
  public HPAScalingPolicyBuilder() {
    this(false);
  }
  public HPAScalingPolicyBuilder(Boolean validationEnabled) {
    this(new HPAScalingPolicy(), validationEnabled);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HPAScalingPolicy(), validationEnabled);
  }
  public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance) {
    this(fluent, instance, false);
  }
  public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPeriodSeconds(instance.getPeriodSeconds()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance) {
    this(instance,false);
  }
  public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPeriodSeconds(instance.getPeriodSeconds()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy build() {
    HPAScalingPolicy buildable = new HPAScalingPolicy(fluent.getPeriodSeconds(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}