package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricSourceBuilder extends ExternalMetricSourceFluentImpl<ExternalMetricSourceBuilder> implements VisitableBuilder<ExternalMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceBuilder>{
  public ExternalMetricSourceBuilder() {
    this(false);
  }
  public ExternalMetricSourceBuilder(Boolean validationEnabled) {
    this(new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetric(instance.getMetric()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance) {
    this(instance,false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetric(instance.getMetric()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource build() {
    ExternalMetricSource buildable = new ExternalMetricSource(fluent.getMetric(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}