package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResourceMetricStatusBuilder extends ContainerResourceMetricStatusFluentImpl<ContainerResourceMetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus,ContainerResourceMetricStatusBuilder>{
  public ContainerResourceMetricStatusBuilder() {
    this(false);
  }
  public ContainerResourceMetricStatusBuilder(Boolean validationEnabled) {
    this(new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainer(instance.getContainer()); 
    fluent.withCurrent(instance.getCurrent()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus instance) {
    this(instance,false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainer(instance.getContainer()); 
    this.withCurrent(instance.getCurrent()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus build() {
    ContainerResourceMetricStatus buildable = new ContainerResourceMetricStatus(fluent.getContainer(),fluent.getCurrent(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}