package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResourceMetricSourceBuilder extends ContainerResourceMetricSourceFluentImpl<ContainerResourceMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource,ContainerResourceMetricSourceBuilder>{
  public ContainerResourceMetricSourceBuilder() {
    this(false);
  }
  public ContainerResourceMetricSourceBuilder(Boolean validationEnabled) {
    this(new ContainerResourceMetricSource(), validationEnabled);
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerResourceMetricSource(), validationEnabled);
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance) {
    this(fluent, instance, false);
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainer(instance.getContainer()); 
    fluent.withName(instance.getName()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance) {
    this(instance,false);
  }
  public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainer(instance.getContainer()); 
    this.withName(instance.getName()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource build() {
    ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(fluent.getContainer(),fluent.getName(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}