package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceMetricStatusFluentImpl<A extends ResourceMetricStatusFluent<A>> extends BaseFluent<A> implements ResourceMetricStatusFluent<A>{
  public ResourceMetricStatusFluentImpl() {
  }
  public ResourceMetricStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance) {
    this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer currentAverageUtilization;
  private Quantity currentAverageValue;
  private String name;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.Integer getCurrentAverageUtilization() {
    return this.currentAverageUtilization;
  }
  public A withCurrentAverageUtilization(java.lang.Integer currentAverageUtilization) {
    this.currentAverageUtilization=currentAverageUtilization; return (A) this;
  }
  public Boolean hasCurrentAverageUtilization() {
    return this.currentAverageUtilization != null;
  }
  public io.fabric8.kubernetes.api.model.Quantity getCurrentAverageValue() {
    return this.currentAverageValue;
  }
  public A withCurrentAverageValue(io.fabric8.kubernetes.api.model.Quantity currentAverageValue) {
    this.currentAverageValue=currentAverageValue; return (A) this;
  }
  public java.lang.Boolean hasCurrentAverageValue() {
    return this.currentAverageValue != null;
  }
  public A withNewCurrentAverageValue(java.lang.String amount,java.lang.String format) {
    return (A)withCurrentAverageValue(new Quantity(amount, format));
  }
  public A withNewCurrentAverageValue(java.lang.String amount) {
    return (A)withCurrentAverageValue(new Quantity(amount));
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceMetricStatusFluentImpl that = (ResourceMetricStatusFluentImpl) o;
    if (currentAverageUtilization != null ? !currentAverageUtilization.equals(that.currentAverageUtilization) :that.currentAverageUtilization != null) return false;
    if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(currentAverageUtilization,  currentAverageValue,  name,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentAverageUtilization != null) { sb.append("currentAverageUtilization:"); sb.append(currentAverageUtilization + ","); }
    if (currentAverageValue != null) { sb.append("currentAverageValue:"); sb.append(currentAverageValue + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}