package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceMetricSourceBuilder extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceBuilder>{
  public ResourceMetricSourceBuilder() {
    this(false);
  }
  public ResourceMetricSourceBuilder(Boolean validationEnabled) {
    this(new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance) {
    this(fluent, instance, false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
    fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance) {
    this(instance,false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource build() {
    ResourceMetricSource buildable = new ResourceMetricSource(fluent.getName(),fluent.getTargetAverageUtilization(),fluent.getTargetAverageValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}