package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodsMetricStatusBuilder extends PodsMetricStatusFluentImpl<PodsMetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusBuilder>{
  public PodsMetricStatusBuilder() {
    this(false);
  }
  public PodsMetricStatusBuilder(Boolean validationEnabled) {
    this(new PodsMetricStatus(), validationEnabled);
  }
  public PodsMetricStatusBuilder(PodsMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodsMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodsMetricStatus(), validationEnabled);
  }
  public PodsMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus instance) {
    this(fluent, instance, false);
  }
  public PodsMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodsMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus instance) {
    this(instance,false);
  }
  public PodsMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus build() {
    PodsMetricStatus buildable = new PodsMetricStatus(fluent.getCurrentAverageValue(),fluent.getMetricName(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}