package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodsMetricSourceBuilder extends PodsMetricSourceFluentImpl<PodsMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceBuilder>{
  public PodsMetricSourceBuilder() {
    this(false);
  }
  public PodsMetricSourceBuilder(Boolean validationEnabled) {
    this(new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PodsMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource instance) {
    this(fluent, instance, false);
  }
  public PodsMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodsMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource instance) {
    this(instance,false);
  }
  public PodsMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricSource build() {
    PodsMetricSource buildable = new PodsMetricSource(fluent.getMetricName(),fluent.getSelector(),fluent.getTargetAverageValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}