package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ObjectMetricStatusFluentImpl<A extends ObjectMetricStatusFluent<A>> extends BaseFluent<A> implements ObjectMetricStatusFluent<A>{
  public ObjectMetricStatusFluentImpl() {
  }
  public ObjectMetricStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus instance) {
    this.withAverageValue(instance.getAverageValue()); 
    this.withCurrentValue(instance.getCurrentValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Quantity averageValue;
  private io.fabric8.kubernetes.api.model.Quantity currentValue;
  private String metricName;
  private LabelSelectorBuilder selector;
  private CrossVersionObjectReferenceBuilder target;
  private Map<java.lang.String,Object> additionalProperties;
  public io.fabric8.kubernetes.api.model.Quantity getAverageValue() {
    return this.averageValue;
  }
  public A withAverageValue(io.fabric8.kubernetes.api.model.Quantity averageValue) {
    this.averageValue=averageValue; return (A) this;
  }
  public Boolean hasAverageValue() {
    return this.averageValue != null;
  }
  public A withNewAverageValue(java.lang.String amount,java.lang.String format) {
    return (A)withAverageValue(new Quantity(amount, format));
  }
  public A withNewAverageValue(java.lang.String amount) {
    return (A)withAverageValue(new Quantity(amount));
  }
  public io.fabric8.kubernetes.api.model.Quantity getCurrentValue() {
    return this.currentValue;
  }
  public A withCurrentValue(io.fabric8.kubernetes.api.model.Quantity currentValue) {
    this.currentValue=currentValue; return (A) this;
  }
  public java.lang.Boolean hasCurrentValue() {
    return this.currentValue != null;
  }
  public A withNewCurrentValue(java.lang.String amount,java.lang.String format) {
    return (A)withCurrentValue(new Quantity(amount, format));
  }
  public A withNewCurrentValue(java.lang.String amount) {
    return (A)withCurrentValue(new Quantity(amount));
  }
  public java.lang.String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(java.lang.String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public java.lang.Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public ObjectMetricStatusFluent.SelectorNested<A> withNewSelector() {
    return new ObjectMetricStatusFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new ObjectMetricStatusFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public CrossVersionObjectReference getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(target); _visitables.get("target").add(this.target);} return (A) this;
  }
  public java.lang.Boolean hasTarget() {
    return this.target != null;
  }
  public A withNewTarget(java.lang.String apiVersion,java.lang.String kind,java.lang.String name) {
    return (A)withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public ObjectMetricStatusFluent.TargetNested<A> withNewTarget() {
    return new ObjectMetricStatusFluentImpl.TargetNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluentImpl.TargetNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl) o;
    if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
    if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
    if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(averageValue,  currentValue,  metricName,  selector,  target,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (averageValue != null) { sb.append("averageValue:"); sb.append(averageValue + ","); }
    if (currentValue != null) { sb.append("currentValue:"); sb.append(currentValue + ","); }
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ObjectMetricStatusFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluent.TargetNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent.TargetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TargetNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}