package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetricStatusBuilder extends ObjectMetricStatusFluentImpl<ObjectMetricStatusBuilder> implements VisitableBuilder<ObjectMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusBuilder>{
  public ObjectMetricStatusBuilder() {
    this(false);
  }
  public ObjectMetricStatusBuilder(Boolean validationEnabled) {
    this(new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAverageValue(instance.getAverageValue()); 
    fluent.withCurrentValue(instance.getCurrentValue()); 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus instance) {
    this(instance,false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAverageValue(instance.getAverageValue()); 
    this.withCurrentValue(instance.getCurrentValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus build() {
    ObjectMetricStatus buildable = new ObjectMetricStatus(fluent.getAverageValue(),fluent.getCurrentValue(),fluent.getMetricName(),fluent.getSelector(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}