package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerSpecBuilder extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec,HorizontalPodAutoscalerSpecBuilder>{
  public HorizontalPodAutoscalerSpecBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerSpec(), validationEnabled);
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxReplicas(instance.getMaxReplicas()); 
    fluent.withMetrics(instance.getMetrics()); 
    fluent.withMinReplicas(instance.getMinReplicas()); 
    fluent.withScaleTargetRef(instance.getScaleTargetRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMetrics(instance.getMetrics()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec build() {
    HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getMaxReplicas(),fluent.getMetrics(),fluent.getMinReplicas(),fluent.getScaleTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}