package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricStatusBuilder extends ExternalMetricStatusFluentImpl<ExternalMetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusBuilder>{
  public ExternalMetricStatusBuilder() {
    this(false);
  }
  public ExternalMetricStatusBuilder(Boolean validationEnabled) {
    this(new ExternalMetricStatus(), validationEnabled);
  }
  public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExternalMetricStatus(), validationEnabled);
  }
  public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    fluent.withCurrentValue(instance.getCurrentValue()); 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withMetricSelector(instance.getMetricSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance) {
    this(instance,false);
  }
  public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withCurrentValue(instance.getCurrentValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withMetricSelector(instance.getMetricSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus build() {
    ExternalMetricStatus buildable = new ExternalMetricStatus(fluent.getCurrentAverageValue(),fluent.getCurrentValue(),fluent.getMetricName(),fluent.getMetricSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}