package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>> extends BaseFluent<A> implements ExternalMetricSourceFluent<A>{
  public ExternalMetricSourceFluentImpl() {
  }
  public ExternalMetricSourceFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance) {
    this.withMetricName(instance.getMetricName()); 
    this.withMetricSelector(instance.getMetricSelector()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withTargetValue(instance.getTargetValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String metricName;
  private LabelSelectorBuilder metricSelector;
  private Quantity targetAverageValue;
  private io.fabric8.kubernetes.api.model.Quantity targetValue;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(java.lang.String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public A withMetricSelector(io.fabric8.kubernetes.api.model.LabelSelector metricSelector) {
    _visitables.get("metricSelector").remove(this.metricSelector);
    if (metricSelector!=null){ this.metricSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} return (A) this;
  }
  public java.lang.Boolean hasMetricSelector() {
    return this.metricSelector != null;
  }
  public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector() {
    return new ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
  }
  public io.fabric8.kubernetes.api.model.Quantity getTargetAverageValue() {
    return this.targetAverageValue;
  }
  public A withTargetAverageValue(io.fabric8.kubernetes.api.model.Quantity targetAverageValue) {
    this.targetAverageValue=targetAverageValue; return (A) this;
  }
  public java.lang.Boolean hasTargetAverageValue() {
    return this.targetAverageValue != null;
  }
  public A withNewTargetAverageValue(java.lang.String amount,java.lang.String format) {
    return (A)withTargetAverageValue(new Quantity(amount, format));
  }
  public A withNewTargetAverageValue(java.lang.String amount) {
    return (A)withTargetAverageValue(new Quantity(amount));
  }
  public io.fabric8.kubernetes.api.model.Quantity getTargetValue() {
    return this.targetValue;
  }
  public A withTargetValue(io.fabric8.kubernetes.api.model.Quantity targetValue) {
    this.targetValue=targetValue; return (A) this;
  }
  public java.lang.Boolean hasTargetValue() {
    return this.targetValue != null;
  }
  public A withNewTargetValue(java.lang.String amount,java.lang.String format) {
    return (A)withTargetValue(new Quantity(amount, format));
  }
  public A withNewTargetValue(java.lang.String amount) {
    return (A)withTargetValue(new Quantity(amount));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl) o;
    if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
    if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
    if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
    if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(metricName,  metricSelector,  targetAverageValue,  targetValue,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (metricSelector != null) { sb.append("metricSelector:"); sb.append(metricSelector + ","); }
    if (targetAverageValue != null) { sb.append("targetAverageValue:"); sb.append(targetAverageValue + ","); }
    if (targetValue != null) { sb.append("targetValue:"); sb.append(targetValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetricSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ExternalMetricSourceFluent.MetricSelectorNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent.MetricSelectorNested<N>,Nested<N>{
    MetricSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    MetricSelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) ExternalMetricSourceFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector() {
      return and();
    }
    
  }
  
}