package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricSourceBuilder extends ExternalMetricSourceFluentImpl<ExternalMetricSourceBuilder> implements VisitableBuilder<ExternalMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceBuilder>{
  public ExternalMetricSourceBuilder() {
    this(false);
  }
  public ExternalMetricSourceBuilder(Boolean validationEnabled) {
    this(new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withMetricSelector(instance.getMetricSelector()); 
    fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
    fluent.withTargetValue(instance.getTargetValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance) {
    this(instance,false);
  }
  public ExternalMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetricName(instance.getMetricName()); 
    this.withMetricSelector(instance.getMetricSelector()); 
    this.withTargetAverageValue(instance.getTargetAverageValue()); 
    this.withTargetValue(instance.getTargetValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricSource build() {
    ExternalMetricSource buildable = new ExternalMetricSource(fluent.getMetricName(),fluent.getMetricSelector(),fluent.getTargetAverageValue(),fluent.getTargetValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}