package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleStatusBuilder extends ScaleStatusFluentImpl<ScaleStatusBuilder> implements VisitableBuilder<ScaleStatus,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusBuilder>{
  public ScaleStatusBuilder() {
    this(false);
  }
  public ScaleStatusBuilder(Boolean validationEnabled) {
    this(new ScaleStatus(), validationEnabled);
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScaleStatus(), validationEnabled);
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance) {
    this(fluent, instance, false);
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance) {
    this(instance,false);
  }
  public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus build() {
    ScaleStatus buildable = new ScaleStatus(fluent.getReplicas(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}