package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleSpecBuilder extends ScaleSpecFluentImpl<ScaleSpecBuilder> implements VisitableBuilder<ScaleSpec,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecBuilder>{
  public ScaleSpecBuilder() {
    this(false);
  }
  public ScaleSpecBuilder(Boolean validationEnabled) {
    this(new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScaleSpec(), validationEnabled);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
    this(fluent, instance, false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
    this(instance,false);
  }
  public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec build() {
    ScaleSpec buildable = new ScaleSpec(fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}