package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerListBuilder extends HorizontalPodAutoscalerListFluentImpl<HorizontalPodAutoscalerListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListBuilder>{
  public HorizontalPodAutoscalerListBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerListBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerList(), validationEnabled);
  }
  public HorizontalPodAutoscalerListBuilder(HorizontalPodAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerList(), validationEnabled);
  }
  public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerListBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerList build() {
    HorizontalPodAutoscalerList buildable = new HorizontalPodAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}