package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerBuilder extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler,HorizontalPodAutoscalerBuilder>{
  public HorizontalPodAutoscalerBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscaler build() {
    HorizontalPodAutoscaler buildable = new HorizontalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}