package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CrossVersionObjectReferenceBuilder extends CrossVersionObjectReferenceFluentImpl<CrossVersionObjectReferenceBuilder> implements VisitableBuilder<CrossVersionObjectReference,io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder>{
  public CrossVersionObjectReferenceBuilder() {
    this(false);
  }
  public CrossVersionObjectReferenceBuilder(Boolean validationEnabled) {
    this(new CrossVersionObjectReference(), validationEnabled);
  }
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public CrossVersionObjectReferenceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CrossVersionObjectReference(), validationEnabled);
  }
  public CrossVersionObjectReferenceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference instance) {
    this(fluent, instance, false);
  }
  public CrossVersionObjectReferenceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CrossVersionObjectReferenceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference instance) {
    this(instance,false);
  }
  public CrossVersionObjectReferenceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference build() {
    CrossVersionObjectReference buildable = new CrossVersionObjectReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}