package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class HorizontalPodAutoscalerSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<A>{
  public HorizontalPodAutoscalerSpecFluentImpl() {
  }
  public HorizontalPodAutoscalerSpecFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance) {
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMetrics(instance.getMetrics()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
  }
  private java.lang.Integer maxReplicas;
  private java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> metrics =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>();
  private java.lang.Integer minReplicas;
  private io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder scaleTargetRef;
  public java.lang.Integer getMaxReplicas() {
    return this.maxReplicas;
  }
  public A withMaxReplicas(java.lang.Integer maxReplicas) {
    this.maxReplicas=maxReplicas; return (A) this;
  }
  public java.lang.Boolean hasMaxReplicas() {
    return this.maxReplicas != null;
  }
  public A addToMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);_visitables.get("metrics").add(index >= 0 ? index : _visitables.get("metrics").size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
  }
  public A setToMetrics(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>();}
    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("metrics").size()) { _visitables.get("metrics").add(builder); } else { _visitables.get("metrics").set(index, builder);}
    if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
     return (A)this;
  }
  public A addToMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec... items) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
  }
  public A addAllToMetrics(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec> items) {
    if (this.metrics == null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>();}
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
  }
  public A removeFromMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec... items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetrics(java.util.Collection<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec> items) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item : items) {io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetrics(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> predicate) {
    if (metrics == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> each = metrics.iterator();
    final List visitables = _visitables.get("metrics");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetrics instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec> getMetrics() {
    return build(metrics);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec> buildMetrics() {
    return build(metrics);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec buildMetric(java.lang.Integer index) {
    return this.metrics.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec buildFirstMetric() {
    return this.metrics.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec buildLastMetric() {
    return this.metrics.get(metrics.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec buildMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetrics(java.util.List<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec> metrics) {
    if (this.metrics != null) { _visitables.get("metrics").removeAll(this.metrics);}
    if (metrics != null) {this.metrics = new java.util.ArrayList<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder>(); for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
  }
  public A withMetrics(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec... metrics) {
    if (this.metrics != null) {this.metrics.clear();}
    if (metrics != null) {for (io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item :metrics){ this.addToMetrics(item);}} return (A) this;
  }
  public java.lang.Boolean hasMetrics() {
    return metrics != null && !metrics.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluentImpl.MetricsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(java.lang.Integer index) {
    if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
    if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
    return setNewMetricLike(0, buildMetric(0));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
    int index = metrics.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(java.util.function.Predicate<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metrics.size();i++) { 
    if (predicate.test(metrics.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
    return setNewMetricLike(index, buildMetric(index));
  }
  public java.lang.Integer getMinReplicas() {
    return this.minReplicas;
  }
  public A withMinReplicas(java.lang.Integer minReplicas) {
    this.minReplicas=minReplicas; return (A) this;
  }
  public java.lang.Boolean hasMinReplicas() {
    return this.minReplicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScaleTargetRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference getScaleTargetRef() {
    return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildScaleTargetRef() {
    return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
  }
  public A withScaleTargetRef(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference scaleTargetRef) {
    _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
    if (scaleTargetRef!=null){ this.scaleTargetRef= new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} return (A) this;
  }
  public java.lang.Boolean hasScaleTargetRef() {
    return this.scaleTargetRef != null;
  }
  public A withNewScaleTargetRef(java.lang.String apiVersion,java.lang.String kind,java.lang.String name) {
    return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
    if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
    if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
    if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
    if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(maxReplicas,  metrics,  minReplicas,  scaleTargetRef,  super.hashCode());
  }
  public class MetricsNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetricsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpec item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(this, item);
    }
    MetricsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(index,builder.build());
    }
    public N endMetric() {
      return and();
    }
    
  }
  public class ScaleTargetRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ScaleTargetRefNestedImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this, item);
    }
    ScaleTargetRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
    }
    public N endScaleTargetRef() {
      return and();
    }
    
  }
  
}