package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
public class HorizontalPodAutoscalerSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent<A>{
  public HorizontalPodAutoscalerSpecFluentImpl() {
  }
  public HorizontalPodAutoscalerSpecFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpec instance) {
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
    this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage()); 
  }
  private java.lang.Integer maxReplicas;
  private java.lang.Integer minReplicas;
  private io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder scaleTargetRef;
  private java.lang.Integer targetCPUUtilizationPercentage;
  public java.lang.Integer getMaxReplicas() {
    return this.maxReplicas;
  }
  public A withMaxReplicas(java.lang.Integer maxReplicas) {
    this.maxReplicas=maxReplicas; return (A) this;
  }
  public java.lang.Boolean hasMaxReplicas() {
    return this.maxReplicas != null;
  }
  public java.lang.Integer getMinReplicas() {
    return this.minReplicas;
  }
  public A withMinReplicas(java.lang.Integer minReplicas) {
    this.minReplicas=minReplicas; return (A) this;
  }
  public java.lang.Boolean hasMinReplicas() {
    return this.minReplicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScaleTargetRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference getScaleTargetRef() {
    return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference buildScaleTargetRef() {
    return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
  }
  public A withScaleTargetRef(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference scaleTargetRef) {
    _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
    if (scaleTargetRef!=null){ this.scaleTargetRef= new io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} return (A) this;
  }
  public java.lang.Boolean hasScaleTargetRef() {
    return this.scaleTargetRef != null;
  }
  public A withNewScaleTargetRef(java.lang.String apiVersion,java.lang.String kind,java.lang.String name) {
    return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
    return new io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference item) {
    return new io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluentImpl.ScaleTargetRefNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference item) {
    return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
  }
  public java.lang.Integer getTargetCPUUtilizationPercentage() {
    return this.targetCPUUtilizationPercentage;
  }
  public A withTargetCPUUtilizationPercentage(java.lang.Integer targetCPUUtilizationPercentage) {
    this.targetCPUUtilizationPercentage=targetCPUUtilizationPercentage; return (A) this;
  }
  public java.lang.Boolean hasTargetCPUUtilizationPercentage() {
    return this.targetCPUUtilizationPercentage != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
    if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
    if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
    if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
    if (targetCPUUtilizationPercentage != null ? !targetCPUUtilizationPercentage.equals(that.targetCPUUtilizationPercentage) :that.targetCPUUtilizationPercentage != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(maxReplicas,  minReplicas,  scaleTargetRef,  targetCPUUtilizationPercentage,  super.hashCode());
  }
  public class ScaleTargetRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ScaleTargetRefNestedImpl(io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder(this, item);
    }
    ScaleTargetRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
    }
    public N endScaleTargetRef() {
      return and();
    }
    
  }
  
}