package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ResourceMetricStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatusFluent<A> {

    private java.lang.Integer currentAverageUtilization;
    private io.fabric8.kubernetes.api.model.Quantity currentAverageValue;
    private java.lang.String name;

    public ResourceMetricStatusFluentImpl() {
    }

    public ResourceMetricStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricStatus instance) {
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
        this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        this.withName(instance.getName()); 
    }

    public java.lang.Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public A withCurrentAverageUtilization(java.lang.Integer currentAverageUtilization) {
        this.currentAverageUtilization=currentAverageUtilization; return (A) this;
    }

    public java.lang.Boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    public io.fabric8.kubernetes.api.model.Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public A withCurrentAverageValue(io.fabric8.kubernetes.api.model.Quantity currentAverageValue) {
        this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public java.lang.Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public A withNewCurrentAverageValue(java.lang.String amount,java.lang.String format) {
        return (A)withCurrentAverageValue(new Quantity(amount, format));
    }

    public A withNewCurrentAverageValue(java.lang.String amount) {
        return (A)withCurrentAverageValue(new Quantity(amount));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourceMetricStatusFluentImpl that = (ResourceMetricStatusFluentImpl) o;
        if (currentAverageUtilization != null ? !currentAverageUtilization.equals(that.currentAverageUtilization) :that.currentAverageUtilization != null) return false;
        if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentAverageUtilization,  currentAverageValue,  name,  super.hashCode());
    }

}
