package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.Scale,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScaleBuilder() {
        this(true);
    }

    public ScaleBuilder(java.lang.Boolean validationEnabled) {
        this(new Scale(), validationEnabled);
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Scale(), validationEnabled);
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.Scale instance) {
        this(fluent, instance, true);
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.Scale instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.Scale instance) {
        this(instance,true);
    }

    public ScaleBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.Scale instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v1.Scale build() {
        Scale buildable = new Scale(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleBuilder that = (ScaleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
