package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceMetricSourceBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceMetricSourceBuilder() {
        this(true);
    }

    public ResourceMetricSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance) {
        this(fluent, instance, true);
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance) {
        this(instance,true);
    }

    public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(fluent.getName(),fluent.getTargetAverageUtilization(),fluent.getTargetAverageValue());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceMetricSourceBuilder that = (ResourceMetricSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
