package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceMetricStatusBuilder() {
        this(true);
    }

    public ResourceMetricStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceMetricStatus(), validationEnabled);
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceMetricStatus(), validationEnabled);
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrent(instance.getCurrent()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus instance) {
        this(instance,true);
    }

    public ResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrent(instance.getCurrent()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricStatus build() {
        ResourceMetricStatus buildable = new ResourceMetricStatus(fluent.getCurrent(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceMetricStatusBuilder that = (ResourceMetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
