package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScaleStatusBuilder() {
        this(true);
    }

    public ScaleStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance) {
        this(fluent, instance, true);
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance) {
        this(instance,true);
    }

    public ScaleStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleStatus build() {
        ScaleStatus buildable = new ScaleStatus(fluent.getReplicas(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleStatusBuilder that = (ScaleStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
