package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ResourceMetricSourceFluentImpl<A extends ResourceMetricSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ResourceMetricSourceFluent<A> {

    private String name;
    private Integer targetAverageUtilization;
    private Quantity targetAverageValue;

    public ResourceMetricSourceFluentImpl() {
    }

    public ResourceMetricSourceFluentImpl(ResourceMetricSource instance) {
        this.withName(instance.getName()); 
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    public A withTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization=targetAverageUtilization; return (A) this;
    }

    public Boolean hasTargetAverageUtilization() {
        return this.targetAverageUtilization != null;
    }

    public A withNewTargetAverageUtilization(int arg0) {
        return (A)withTargetAverageUtilization(new Integer(arg0));
    }

    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(String amount) {
        return (A)withTargetAverageValue(new Quantity(amount));
    }

    public A withNewTargetAverageValue(String amount,String format) {
        return (A)withTargetAverageValue(new Quantity(amount, format));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourceMetricSourceFluentImpl that = (ResourceMetricSourceFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (targetAverageUtilization != null ? !targetAverageUtilization.equals(that.targetAverageUtilization) :that.targetAverageUtilization != null) return false;
        if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  targetAverageUtilization,  targetAverageValue,  super.hashCode());
    }

}
