package io.fabric8.kubernetes.api.model.autoscaling.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getCurrentCPUUtilizationPercentage();
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage);
    public Boolean hasCurrentCPUUtilizationPercentage();
    public A withNewCurrentCPUUtilizationPercentage(int arg0);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public A withNewCurrentReplicas(int arg0);
    public Integer getDesiredReplicas();
    public A withDesiredReplicas(Integer desiredReplicas);
    public Boolean hasDesiredReplicas();
    public A withNewDesiredReplicas(int arg0);
    public String getLastScaleTime();
    public A withLastScaleTime(String lastScaleTime);
    public Boolean hasLastScaleTime();
    public A withNewLastScaleTime(StringBuilder arg1);
    public A withNewLastScaleTime(int[] arg1,int arg2,int arg3);
    public A withNewLastScaleTime(char[] arg1);
    public A withNewLastScaleTime(StringBuffer arg1);
    public A withNewLastScaleTime(byte[] arg1,int arg2);
    public A withNewLastScaleTime(byte[] arg1);
    public A withNewLastScaleTime(char[] arg1,int arg2,int arg3);
    public A withNewLastScaleTime(byte[] arg1,int arg2,int arg3);
    public A withNewLastScaleTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLastScaleTime(String arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
}
