package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class MetricSpecFluentImpl<A extends MetricSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricSpecFluent<A> {

    private ContainerResourceMetricSourceBuilder containerResource;
    private ExternalMetricSourceBuilder external;
    private ObjectMetricSourceBuilder object;
    private PodsMetricSourceBuilder pods;
    private ResourceMetricSourceBuilder resource;
    private String type;

    public MetricSpecFluentImpl() {
    }

    public MetricSpecFluentImpl(MetricSpec instance) {
        this.withContainerResource(instance.getContainerResource()); 
        this.withExternal(instance.getExternal()); 
        this.withObject(instance.getObject()); 
        this.withPods(instance.getPods()); 
        this.withResource(instance.getResource()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildContainerResource instead.
 * @return The buildable object.
 */
@Deprecated public ContainerResourceMetricSource getContainerResource() {
        return this.containerResource!=null?this.containerResource.build():null;
    }

    public ContainerResourceMetricSource buildContainerResource() {
        return this.containerResource!=null?this.containerResource.build():null;
    }

    public A withContainerResource(ContainerResourceMetricSource containerResource) {
        _visitables.get("containerResource").remove(this.containerResource);
        if (containerResource!=null){ this.containerResource= new ContainerResourceMetricSourceBuilder(containerResource); _visitables.get("containerResource").add(this.containerResource);} return (A) this;
    }

    public Boolean hasContainerResource() {
        return this.containerResource != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<A> withNewContainerResource() {
        return new ContainerResourceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<A> withNewContainerResourceLike(ContainerResourceMetricSource item) {
        return new ContainerResourceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<A> editContainerResource() {
        return withNewContainerResourceLike(getContainerResource());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<A> editOrNewContainerResource() {
        return withNewContainerResourceLike(getContainerResource() != null ? getContainerResource(): new ContainerResourceMetricSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<A> editOrNewContainerResourceLike(ContainerResourceMetricSource item) {
        return withNewContainerResourceLike(getContainerResource() != null ? getContainerResource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildExternal instead.
 * @return The buildable object.
 */
@Deprecated public ExternalMetricSource getExternal() {
        return this.external!=null?this.external.build():null;
    }

    public ExternalMetricSource buildExternal() {
        return this.external!=null?this.external.build():null;
    }

    public A withExternal(ExternalMetricSource external) {
        _visitables.get("external").remove(this.external);
        if (external!=null){ this.external= new ExternalMetricSourceBuilder(external); _visitables.get("external").add(this.external);} return (A) this;
    }

    public Boolean hasExternal() {
        return this.external != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<A> withNewExternal() {
        return new ExternalNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<A> withNewExternalLike(ExternalMetricSource item) {
        return new ExternalNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<A> editExternal() {
        return withNewExternalLike(getExternal());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<A> editOrNewExternal() {
        return withNewExternalLike(getExternal() != null ? getExternal(): new ExternalMetricSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<A> editOrNewExternalLike(ExternalMetricSource item) {
        return withNewExternalLike(getExternal() != null ? getExternal(): item);
    }

    
/**
 * This method has been deprecated, please use method buildObject instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMetricSource getObject() {
        return this.object!=null?this.object.build():null;
    }

    public ObjectMetricSource buildObject() {
        return this.object!=null?this.object.build():null;
    }

    public A withObject(ObjectMetricSource object) {
        _visitables.get("object").remove(this.object);
        if (object!=null){ this.object= new ObjectMetricSourceBuilder(object); _visitables.get("object").add(this.object);} return (A) this;
    }

    public Boolean hasObject() {
        return this.object != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<A> withNewObject() {
        return new ObjectNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<A> withNewObjectLike(ObjectMetricSource item) {
        return new ObjectNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<A> editObject() {
        return withNewObjectLike(getObject());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<A> editOrNewObject() {
        return withNewObjectLike(getObject() != null ? getObject(): new ObjectMetricSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<A> editOrNewObjectLike(ObjectMetricSource item) {
        return withNewObjectLike(getObject() != null ? getObject(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPods instead.
 * @return The buildable object.
 */
@Deprecated public PodsMetricSource getPods() {
        return this.pods!=null?this.pods.build():null;
    }

    public PodsMetricSource buildPods() {
        return this.pods!=null?this.pods.build():null;
    }

    public A withPods(PodsMetricSource pods) {
        _visitables.get("pods").remove(this.pods);
        if (pods!=null){ this.pods= new PodsMetricSourceBuilder(pods); _visitables.get("pods").add(this.pods);} return (A) this;
    }

    public Boolean hasPods() {
        return this.pods != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<A> withNewPods() {
        return new PodsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<A> withNewPodsLike(PodsMetricSource item) {
        return new PodsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<A> editPods() {
        return withNewPodsLike(getPods());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<A> editOrNewPods() {
        return withNewPodsLike(getPods() != null ? getPods(): new PodsMetricSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<A> editOrNewPodsLike(PodsMetricSource item) {
        return withNewPodsLike(getPods() != null ? getPods(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResource instead.
 * @return The buildable object.
 */
@Deprecated public ResourceMetricSource getResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public ResourceMetricSource buildResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public A withResource(ResourceMetricSource resource) {
        _visitables.get("resource").remove(this.resource);
        if (resource!=null){ this.resource= new ResourceMetricSourceBuilder(resource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<A> withNewResource() {
        return new ResourceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<A> withNewResourceLike(ResourceMetricSource item) {
        return new ResourceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<A> editResource() {
        return withNewResourceLike(getResource());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<A> editOrNewResource() {
        return withNewResourceLike(getResource() != null ? getResource(): new ResourceMetricSourceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<A> editOrNewResourceLike(ResourceMetricSource item) {
        return withNewResourceLike(getResource() != null ? getResource(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MetricSpecFluentImpl that = (MetricSpecFluentImpl) o;
        if (containerResource != null ? !containerResource.equals(that.containerResource) :that.containerResource != null) return false;
        if (external != null ? !external.equals(that.external) :that.external != null) return false;
        if (object != null ? !object.equals(that.object) :that.object != null) return false;
        if (pods != null ? !pods.equals(that.pods) :that.pods != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(containerResource,  external,  object,  pods,  resource,  type,  super.hashCode());
    }

    public class ContainerResourceNestedImpl<N> extends ContainerResourceMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ContainerResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerResourceMetricSourceBuilder builder;

            ContainerResourceNestedImpl(ContainerResourceMetricSource item) {
                this.builder = new ContainerResourceMetricSourceBuilder(this, item);
                        
            }

            ContainerResourceNestedImpl() {
                this.builder = new ContainerResourceMetricSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MetricSpecFluentImpl.this.withContainerResource(builder.build());
            }

            public N endContainerResource() {
                return and();
            }
    }


    public class ExternalNestedImpl<N> extends ExternalMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ExternalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalMetricSourceBuilder builder;

            ExternalNestedImpl(ExternalMetricSource item) {
                this.builder = new ExternalMetricSourceBuilder(this, item);
                        
            }

            ExternalNestedImpl() {
                this.builder = new ExternalMetricSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MetricSpecFluentImpl.this.withExternal(builder.build());
            }

            public N endExternal() {
                return and();
            }
    }


    public class ObjectNestedImpl<N> extends ObjectMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ObjectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetricSourceBuilder builder;

            ObjectNestedImpl(ObjectMetricSource item) {
                this.builder = new ObjectMetricSourceBuilder(this, item);
                        
            }

            ObjectNestedImpl() {
                this.builder = new ObjectMetricSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MetricSpecFluentImpl.this.withObject(builder.build());
            }

            public N endObject() {
                return and();
            }
    }


    public class PodsNestedImpl<N> extends PodsMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.PodsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodsMetricSourceBuilder builder;

            PodsNestedImpl(PodsMetricSource item) {
                this.builder = new PodsMetricSourceBuilder(this, item);
                        
            }

            PodsNestedImpl() {
                this.builder = new PodsMetricSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MetricSpecFluentImpl.this.withPods(builder.build());
            }

            public N endPods() {
                return and();
            }
    }


    public class ResourceNestedImpl<N> extends ResourceMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<N>> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.MetricSpecFluent.ResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceMetricSourceBuilder builder;

            ResourceNestedImpl(ResourceMetricSource item) {
                this.builder = new ResourceMetricSourceBuilder(this, item);
                        
            }

            ResourceNestedImpl() {
                this.builder = new ResourceMetricSourceBuilder(this);
                        
            }

            public N and() {
                return (N) MetricSpecFluentImpl.this.withResource(builder.build());
            }

            public N endResource() {
                return and();
            }
    }


}
