package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface HorizontalPodAutoscalerSpecFluent<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMaxReplicas();
    public A withMaxReplicas(Integer maxReplicas);
    public Boolean hasMaxReplicas();
    public A withNewMaxReplicas(int arg0);
    public A addToMetrics(int index,MetricSpec item);
    public A setToMetrics(int index,MetricSpec item);
    public A addToMetrics(MetricSpec... items);
    public A addAllToMetrics(Collection<MetricSpec> items);
    public A removeFromMetrics(MetricSpec... items);
    public A removeAllFromMetrics(Collection<MetricSpec> items);
    public A removeMatchingFromMetrics(Predicate<MetricSpecBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricSpec> getMetrics();
    public List<MetricSpec> buildMetrics();
    public MetricSpec buildMetric(int index);
    public MetricSpec buildFirstMetric();
    public MetricSpec buildLastMetric();
    public MetricSpec buildMatchingMetric(Predicate<MetricSpecBuilder> predicate);
    public Boolean hasMatchingMetric(Predicate<MetricSpecBuilder> predicate);
    public A withMetrics(List<MetricSpec> metrics);
    public A withMetrics(MetricSpec... metrics);
    public Boolean hasMetrics();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(MetricSpec item);
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricSpec item);
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(int index);
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<MetricSpecBuilder> predicate);
    public Integer getMinReplicas();
    public A withMinReplicas(Integer minReplicas);
    public Boolean hasMinReplicas();
    public A withNewMinReplicas(int arg0);
    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference getScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildScaleTargetRef();
    public A withScaleTargetRef(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference scaleTargetRef);
    public Boolean hasScaleTargetRef();
    public A withNewScaleTargetRef(String apiVersion,String kind,String name);
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item);
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item);
    public interface MetricsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MetricSpecFluent<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.MetricsNested<N>> {

            public N and();
            public N endMetric();    }


    public interface ScaleTargetRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluent<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> {

            public N and();
            public N endScaleTargetRef();    }


}
