package io.fabric8.kubernetes.api.model.autoscaling.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMaxReplicas();
    public A withMaxReplicas(Integer maxReplicas);
    public Boolean hasMaxReplicas();
    public A withNewMaxReplicas(int arg0);
    public Integer getMinReplicas();
    public A withMinReplicas(Integer minReplicas);
    public Boolean hasMinReplicas();
    public A withNewMinReplicas(int arg0);
    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public CrossVersionObjectReference getScaleTargetRef();
    public CrossVersionObjectReference buildScaleTargetRef();
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef);
    public Boolean hasScaleTargetRef();
    public A withNewScaleTargetRef(String apiVersion,String kind,String name);
    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item);
    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef();
    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item);
    public Integer getTargetCPUUtilizationPercentage();
    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage);
    public Boolean hasTargetCPUUtilizationPercentage();
    public A withNewTargetCPUUtilizationPercentage(int arg0);
    public interface ScaleTargetRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CrossVersionObjectReferenceFluent<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> {

            public N and();
            public N endScaleTargetRef();    }


}
