package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerResourceMetricSourceBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerResourceMetricSourceBuilder() {
        this(true);
    }

    public ContainerResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance) {
        this(fluent, instance, true);
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainer(instance.getContainer()); 
        fluent.withName(instance.getName()); 
        fluent.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance) {
        this(instance,true);
    }

    public ContainerResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainer(instance.getContainer()); 
        this.withName(instance.getName()); 
        this.withTarget(instance.getTarget()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource build() {
        ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(fluent.getContainer(),fluent.getName(),fluent.getTarget());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerResourceMetricSourceBuilder that = (ContainerResourceMetricSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
