package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerResourceMetricStatusFluent<A extends ContainerResourceMetricStatusFluent<A>> extends Fluent<A> {


    public String getContainer();
    public A withContainer(String container);
    public Boolean hasContainer();
    public A withNewContainer(StringBuilder arg1);
    public A withNewContainer(int[] arg1,int arg2,int arg3);
    public A withNewContainer(char[] arg1);
    public A withNewContainer(StringBuffer arg1);
    public A withNewContainer(byte[] arg1,int arg2);
    public A withNewContainer(byte[] arg1);
    public A withNewContainer(char[] arg1,int arg2,int arg3);
    public A withNewContainer(byte[] arg1,int arg2,int arg3);
    public A withNewContainer(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewContainer(String arg1);
    public Integer getCurrentAverageUtilization();
    public A withCurrentAverageUtilization(Integer currentAverageUtilization);
    public Boolean hasCurrentAverageUtilization();
    public A withNewCurrentAverageUtilization(int arg1);
    public Quantity getCurrentAverageValue();
    public A withCurrentAverageValue(Quantity currentAverageValue);
    public Boolean hasCurrentAverageValue();
    public A withNewCurrentAverageValue(String amount);
    public A withNewCurrentAverageValue(String amount,String format);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
}
