package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class MetricValueStatusFluentImpl<A extends MetricValueStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricValueStatusFluent<A> {

    private Integer averageUtilization;
    private Quantity averageValue;
    private Quantity value;

    public MetricValueStatusFluentImpl() {
    }

    public MetricValueStatusFluentImpl(MetricValueStatus instance) {
        this.withAverageUtilization(instance.getAverageUtilization()); 
        this.withAverageValue(instance.getAverageValue()); 
        this.withValue(instance.getValue()); 
    }

    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization=averageUtilization; return (A) this;
    }

    public Boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    public A withNewAverageUtilization(int arg1) {
        return (A)withAverageUtilization(new Integer(arg1));
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue=averageValue; return (A) this;
    }

    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String amount) {
        return (A)withAverageValue(new Quantity(amount));
    }

    public A withNewAverageValue(String amount,String format) {
        return (A)withAverageValue(new Quantity(amount, format));
    }

    public Quantity getValue() {
        return this.value;
    }

    public A withValue(Quantity value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String amount) {
        return (A)withValue(new Quantity(amount));
    }

    public A withNewValue(String amount,String format) {
        return (A)withValue(new Quantity(amount, format));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MetricValueStatusFluentImpl that = (MetricValueStatusFluentImpl) o;
        if (averageUtilization != null ? !averageUtilization.equals(that.averageUtilization) :that.averageUtilization != null) return false;
        if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(averageUtilization,  averageValue,  value,  super.hashCode());
    }

}
