package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerResourceMetricStatusBuilder extends ContainerResourceMetricStatusFluentImpl<ContainerResourceMetricStatusBuilder> implements VisitableBuilder<ContainerResourceMetricStatus,ContainerResourceMetricStatusBuilder> {

    ContainerResourceMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerResourceMetricStatusBuilder() {
        this(true);
    }

    public ContainerResourceMetricStatusBuilder(Boolean validationEnabled) {
        this(new ContainerResourceMetricStatus(), validationEnabled);
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerResourceMetricStatus(), validationEnabled);
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,ContainerResourceMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatusFluent<?> fluent,ContainerResourceMetricStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainer(instance.getContainer()); 
        fluent.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
        fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatus instance) {
        this(instance,true);
    }

    public ContainerResourceMetricStatusBuilder(ContainerResourceMetricStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainer(instance.getContainer()); 
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
        this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerResourceMetricStatus build() {
        ContainerResourceMetricStatus buildable = new ContainerResourceMetricStatus(fluent.getContainer(),fluent.getCurrentAverageUtilization(),fluent.getCurrentAverageValue(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerResourceMetricStatusBuilder that = (ContainerResourceMetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
