package io.fabric8.kubernetes.api.model.autoscaling.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ScaleStatusFluentImpl<A extends ScaleStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ScaleStatusFluent<A> {

    private Integer replicas;
    private String selector;

    public ScaleStatusFluentImpl() {
    }

    public ScaleStatusFluentImpl(ScaleStatus instance) {
        this.withReplicas(instance.getReplicas()); 
        this.withSelector(instance.getSelector()); 
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A withNewReplicas(int arg1) {
        return (A)withReplicas(new Integer(arg1));
    }

    public String getSelector() {
        return this.selector;
    }

    public A withSelector(String selector) {
        this.selector=selector; return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public A withNewSelector(StringBuilder arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(int[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(char[] arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(StringBuffer arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(byte[] arg1,int arg2) {
        return (A)withSelector(new String(arg1, arg2));
    }

    public A withNewSelector(byte[] arg1) {
        return (A)withSelector(new String(arg1));
    }

    public A withNewSelector(char[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withSelector(new String(arg1, arg2, arg3));
    }

    public A withNewSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSelector(String arg1) {
        return (A)withSelector(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ScaleStatusFluentImpl that = (ScaleStatusFluentImpl) o;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  selector,  super.hashCode());
    }

}
