package io.fabric8.kubernetes.api.model.autoscaling.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerSpecFluent<A extends HorizontalPodAutoscalerSpecFluent<A>> extends Fluent<A> {


    public Integer getMaxReplicas();
    public A withMaxReplicas(Integer maxReplicas);
    public Boolean hasMaxReplicas();
    public A withNewMaxReplicas(int arg1);
    public Integer getMinReplicas();
    public A withMinReplicas(Integer minReplicas);
    public Boolean hasMinReplicas();
    public A withNewMinReplicas(int arg1);
    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public CrossVersionObjectReference getScaleTargetRef();
    public CrossVersionObjectReference buildScaleTargetRef();
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef);
    public Boolean hasScaleTargetRef();
    public A withNewScaleTargetRef(String apiVersion,String kind,String name);
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef();
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item);
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef();
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef();
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item);
    public Integer getTargetCPUUtilizationPercentage();
    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage);
    public Boolean hasTargetCPUUtilizationPercentage();
    public A withNewTargetCPUUtilizationPercentage(int arg1);
    public interface ScaleTargetRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CrossVersionObjectReferenceFluent<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> {

            public N and();
            public N endScaleTargetRef();    }


}
