package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerSpecBuilder extends HorizontalPodAutoscalerSpecFluentImpl<HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<HorizontalPodAutoscalerSpec,HorizontalPodAutoscalerSpecBuilder> {

    HorizontalPodAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerSpecBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMaxReplicas(instance.getMaxReplicas()); 
        fluent.withMinReplicas(instance.getMinReplicas()); 
        fluent.withScaleTargetRef(instance.getScaleTargetRef()); 
        fluent.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance) {
        this(instance,true);
    }

    public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMaxReplicas(instance.getMaxReplicas()); 
        this.withMinReplicas(instance.getMinReplicas()); 
        this.withScaleTargetRef(instance.getScaleTargetRef()); 
        this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerSpec build() {
        HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getScaleTargetRef(),fluent.getTargetCPUUtilizationPercentage());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
