package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerResourceMetricSourceBuilder extends ContainerResourceMetricSourceFluentImpl<ContainerResourceMetricSourceBuilder> implements VisitableBuilder<ContainerResourceMetricSource,ContainerResourceMetricSourceBuilder> {

    ContainerResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerResourceMetricSourceBuilder() {
        this(true);
    }

    public ContainerResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerResourceMetricSource(), validationEnabled);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,ContainerResourceMetricSource instance) {
        this(fluent, instance, true);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,ContainerResourceMetricSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withContainer(instance.getContainer()); 
        fluent.withName(instance.getName()); 
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance) {
        this(instance,true);
    }

    public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withContainer(instance.getContainer()); 
        this.withName(instance.getName()); 
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization()); 
        this.withTargetAverageValue(instance.getTargetAverageValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerResourceMetricSource build() {
        ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(fluent.getContainer(),fluent.getName(),fluent.getTargetAverageUtilization(),fluent.getTargetAverageValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerResourceMetricSourceBuilder that = (ContainerResourceMetricSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
