package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ResourceMetricStatusFluent<A extends ResourceMetricStatusFluent<A>> extends Fluent<A> {


    public Integer getCurrentAverageUtilization();
    public A withCurrentAverageUtilization(Integer currentAverageUtilization);
    public Boolean hasCurrentAverageUtilization();
    public A withNewCurrentAverageUtilization(String arg1);
    public A withNewCurrentAverageUtilization(int arg1);
    public Quantity getCurrentAverageValue();
    public A withCurrentAverageValue(Quantity currentAverageValue);
    public Boolean hasCurrentAverageValue();
    public A withNewCurrentAverageValue(String amount,String format);
    public A withNewCurrentAverageValue(String amount);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
}
