package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ContainerResourceMetricStatusFluentImpl<A extends ContainerResourceMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerResourceMetricStatusFluent<A> {

    private String container;
    private Integer currentAverageUtilization;
    private Quantity currentAverageValue;
    private String name;

    public ContainerResourceMetricStatusFluentImpl() {
    }

    public ContainerResourceMetricStatusFluentImpl(ContainerResourceMetricStatus instance) {
        this.withContainer(instance.getContainer()); 
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
        this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        this.withName(instance.getName()); 
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container=container; return (A) this;
    }

    public Boolean hasContainer() {
        return this.container != null;
    }

    public A withNewContainer(String arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuilder arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuffer arg1) {
        return (A)withContainer(new String(arg1));
    }

    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization=currentAverageUtilization; return (A) this;
    }

    public Boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    public A withNewCurrentAverageUtilization(String arg1) {
        return (A)withCurrentAverageUtilization(new Integer(arg1));
    }

    public A withNewCurrentAverageUtilization(int arg1) {
        return (A)withCurrentAverageUtilization(new Integer(arg1));
    }

    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public A withNewCurrentAverageValue(String amount,String format) {
        return (A)withCurrentAverageValue(new Quantity(amount, format));
    }

    public A withNewCurrentAverageValue(String amount) {
        return (A)withCurrentAverageValue(new Quantity(amount));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContainerResourceMetricStatusFluentImpl that = (ContainerResourceMetricStatusFluentImpl) o;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (currentAverageUtilization != null ? !currentAverageUtilization.equals(that.currentAverageUtilization) :that.currentAverageUtilization != null) return false;
        if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(container,  currentAverageUtilization,  currentAverageValue,  name,  super.hashCode());
    }

}
