package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerResourceMetricStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatusFluent<A> {

    private String container;
    private MetricValueStatusBuilder current;
    private String name;

    public ContainerResourceMetricStatusFluentImpl() {
    }

    public ContainerResourceMetricStatusFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricStatus instance) {
        this.withContainer(instance.getContainer()); 
        this.withCurrent(instance.getCurrent()); 
        this.withName(instance.getName()); 
    }

    public String getContainer() {
        return this.container;
    }

    public A withContainer(String container) {
        this.container=container; return (A) this;
    }

    public Boolean hasContainer() {
        return this.container != null;
    }

    public A withNewContainer(String arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuilder arg1) {
        return (A)withContainer(new String(arg1));
    }

    public A withNewContainer(StringBuffer arg1) {
        return (A)withContainer(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCurrent instead.
 * @return The buildable object.
 */
@Deprecated public MetricValueStatus getCurrent() {
        return this.current!=null?this.current.build():null;
    }

    public MetricValueStatus buildCurrent() {
        return this.current!=null?this.current.build():null;
    }

    public A withCurrent(MetricValueStatus current) {
        _visitables.get("current").remove(this.current);
        if (current!=null){ this.current= new MetricValueStatusBuilder(current); _visitables.get("current").add(this.current);} return (A) this;
    }

    public Boolean hasCurrent() {
        return this.current != null;
    }

    public ContainerResourceMetricStatusFluent.CurrentNested<A> withNewCurrent() {
        return new CurrentNestedImpl();
    }

    public ContainerResourceMetricStatusFluent.CurrentNested<A> withNewCurrentLike(MetricValueStatus item) {
        return new CurrentNestedImpl(item);
    }

    public ContainerResourceMetricStatusFluent.CurrentNested<A> editCurrent() {
        return withNewCurrentLike(getCurrent());
    }

    public ContainerResourceMetricStatusFluent.CurrentNested<A> editOrNewCurrent() {
        return withNewCurrentLike(getCurrent() != null ? getCurrent(): new MetricValueStatusBuilder().build());
    }

    public ContainerResourceMetricStatusFluent.CurrentNested<A> editOrNewCurrentLike(MetricValueStatus item) {
        return withNewCurrentLike(getCurrent() != null ? getCurrent(): item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContainerResourceMetricStatusFluentImpl that = (ContainerResourceMetricStatusFluentImpl) o;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (current != null ? !current.equals(that.current) :that.current != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(container,  current,  name,  super.hashCode());
    }

    public class CurrentNestedImpl<N> extends MetricValueStatusFluentImpl<ContainerResourceMetricStatusFluent.CurrentNested<N>> implements ContainerResourceMetricStatusFluent.CurrentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetricValueStatusBuilder builder;

            CurrentNestedImpl(MetricValueStatus item) {
                this.builder = new MetricValueStatusBuilder(this, item);
                        
            }

            CurrentNestedImpl() {
                this.builder = new MetricValueStatusBuilder(this);
                        
            }

            public N and() {
                return (N) ContainerResourceMetricStatusFluentImpl.this.withCurrent(builder.build());
            }

            public N endCurrent() {
                return and();
            }
    }


}
