package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricStatusFluentImpl<A extends ExternalMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalMetricStatusFluent<A> {

    private Quantity currentAverageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder metricSelector;

    public ExternalMetricStatusFluentImpl() {
    }

    public ExternalMetricStatusFluentImpl(ExternalMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        this.withCurrentValue(instance.getCurrentValue()); 
        this.withMetricName(instance.getMetricName()); 
        this.withMetricSelector(instance.getMetricSelector()); 
    }

    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public A withNewCurrentAverageValue(String amount,String format) {
        return (A)withCurrentAverageValue(new Quantity(amount, format));
    }

    public A withNewCurrentAverageValue(String amount) {
        return (A)withCurrentAverageValue(new Quantity(amount));
    }

    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    public A withCurrentValue(Quantity currentValue) {
        this.currentValue=currentValue; return (A) this;
    }

    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    public A withNewCurrentValue(String amount,String format) {
        return (A)withCurrentValue(new Quantity(amount, format));
    }

    public A withNewCurrentValue(String amount) {
        return (A)withCurrentValue(new Quantity(amount));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(String metricName) {
        this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    public A withNewMetricName(String arg1) {
        return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1) {
        return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1) {
        return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getMetricSelector() {
        return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public LabelSelector buildMetricSelector() {
        return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public A withMetricSelector(LabelSelector metricSelector) {
        _visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector!=null){ this.metricSelector= new LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} return (A) this;
    }

    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    public ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector() {
        return withNewMetricSelectorLike(getMetricSelector());
    }

    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new LabelSelectorBuilder().build());
    }

    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalMetricStatusFluentImpl that = (ExternalMetricStatusFluentImpl) o;
        if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
        if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
        if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
        if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentAverageValue,  currentValue,  metricName,  metricSelector,  super.hashCode());
    }

    public class MetricSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ExternalMetricStatusFluent.MetricSelectorNested<N>> implements ExternalMetricStatusFluent.MetricSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            MetricSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            MetricSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalMetricStatusFluentImpl.this.withMetricSelector(builder.build());
            }

            public N endMetricSelector() {
                return and();
            }
    }


}
