package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ObjectMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ObjectMetricStatusBuilder() {
        this(true);
    }

    public ObjectMetricStatusBuilder(Boolean validationEnabled) {
        this(new ObjectMetricStatus(), validationEnabled);
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ObjectMetricStatus(), validationEnabled);
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrent(instance.getCurrent()); 
        fluent.withDescribedObject(instance.getDescribedObject()); 
        fluent.withMetric(instance.getMetric()); 
        this.validationEnabled = validationEnabled; 
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance) {
        this(instance,true);
    }

    public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrent(instance.getCurrent()); 
        this.withDescribedObject(instance.getDescribedObject()); 
        this.withMetric(instance.getMetric()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus build() {
        ObjectMetricStatus buildable = new ObjectMetricStatus(fluent.getCurrent(),fluent.getDescribedObject(),fluent.getMetric());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ObjectMetricStatusBuilder that = (ObjectMetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
