package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface ObjectMetricSourceFluent<A extends ObjectMetricSourceFluent<A>> extends Fluent<A> {


    public Quantity getAverageValue();
    public A withAverageValue(Quantity averageValue);
    public Boolean hasAverageValue();
    public A withNewAverageValue(String amount,String format);
    public A withNewAverageValue(String amount);
    public String getMetricName();
    public A withMetricName(String metricName);
    public Boolean hasMetricName();
    public A withNewMetricName(String arg1);
    public A withNewMetricName(StringBuilder arg1);
    public A withNewMetricName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelector();
    public ObjectMetricSourceFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public ObjectMetricSourceFluent.SelectorNested<A> editSelector();
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelector();
    public ObjectMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference getTarget();
    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildTarget();
    public A withTarget(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference target);
    public Boolean hasTarget();
    public A withNewTarget(String apiVersion,String kind,String name);
    public ObjectMetricSourceFluent.TargetNested<A> withNewTarget();
    public ObjectMetricSourceFluent.TargetNested<A> withNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item);
    public ObjectMetricSourceFluent.TargetNested<A> editTarget();
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTarget();
    public ObjectMetricSourceFluent.TargetNested<A> editOrNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item);
    public Quantity getTargetValue();
    public A withTargetValue(Quantity targetValue);
    public Boolean hasTargetValue();
    public A withNewTargetValue(String amount,String format);
    public A withNewTargetValue(String amount);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ObjectMetricSourceFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface TargetNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluent<ObjectMetricSourceFluent.TargetNested<N>> {

            public N and();
            public N endTarget();    }


}
